
using System;
using System.Collections.Generic;
using System.Text;

namespace PI.ZB.N1200.ELearning.BL.DBD
{
    internal class Class : PI.FM.N000.Base.BL.DBD.BaseTable<BO.Class>
    {
        #region Static factory
        private static Class _factory = null;

        public static Class DBD
        {
            get
            {
                if (_factory == null)
                {
                    _factory = new Class();
                }
                return _factory;
            }
        }
        #endregion

        #region Override - Initialization
        protected override void InitializeTableName()
        {
            _tableName = "PIZB1200_Class";
        }

        protected override void InitializeProperties()
        {
            Add(new PI.FM.N000.Base.BL.DBD.LongProperty("SchoolID", "SchoolID", true));
            Add(new PI.FM.N000.Base.BL.DBD.LongProperty("SchoolYearID", "SchoolYearID", true));            
            Add(new PI.FM.N000.Base.BL.DBD.LongProperty("InstructorID", "InstructorID", true));
            Add(new PI.FM.N000.Base.BL.DBD.StringProperty("Name", "Name", true));
        }
        #endregion

        #region Commands definition
        public enum Commands
        {
            RestoreBySearch = 20,
            CountBySearch = 21,
            RemoveBySearch = 22
        }
        #endregion

        #region Get Commands
        protected override Gemini.Core.BL.Interface.DBD.ICommand DoGetCommand(int CommandID)
        {
            switch (CommandID)
            {
                case (int)Commands.RestoreBySearch: return new Command_RestoreBySearch();
                case (int)Commands.CountBySearch: return new Command_CountBySearch();
                case (int)Commands.RemoveBySearch: return new Command_RemoveBySearch(); 
            }

            return base.DoGetCommand(CommandID);
        }
        #endregion

        #region Additional Commands Classes
        class Command_RestoreBySearch : PI.FM.N000.Base.BL.DBD.BaseCommand<BO.Class>
        {
            public Command_RestoreBySearch() : base(PI.ZB.N1200.ELearning.BL.DBD.Class.DBD, Gemini.Core.BL.DBD.CommandType.StoredProcedure) { }

            protected override void InitializeParametrs()
            {
                Add(new Gemini.Core.BL.DBD.Param("SchoolID", Gemini.Core.BL.DAL.SqlTypes.BigInt));
                Add(new Gemini.Core.BL.DBD.Param("SchoolYearID", Gemini.Core.BL.DAL.SqlTypes.BigInt));
                Add(new Gemini.Core.BL.DBD.Param("InstructorID", Gemini.Core.BL.DAL.SqlTypes.BigInt));
                Add(new Gemini.Core.BL.DBD.Param("Name", Gemini.Core.BL.DAL.SqlTypes.NVarChar));
            }

            protected override void InitializeCommandText()
            {
                _commandText = "PIZB1200_Class_RestoreBySearch";
            }
        }

        class Command_CountBySearch : PI.FM.N000.Base.BL.DBD.BaseCommand<BO.Class>
        {
            public Command_CountBySearch() : base(PI.ZB.N1200.ELearning.BL.DBD.Class.DBD, Gemini.Core.BL.DBD.CommandType.StoredProcedure) { }

            protected override void InitializeParametrs()
            {
                Add(new Gemini.Core.BL.DBD.Param("SchoolID", Gemini.Core.BL.DAL.SqlTypes.BigInt));
                Add(new Gemini.Core.BL.DBD.Param("SchoolYearID", Gemini.Core.BL.DAL.SqlTypes.BigInt));
                Add(new Gemini.Core.BL.DBD.Param("InstructorID", Gemini.Core.BL.DAL.SqlTypes.BigInt));
                Add(new Gemini.Core.BL.DBD.Param("Name", Gemini.Core.BL.DAL.SqlTypes.NVarChar));
                Add(new Gemini.Core.BL.DBD.Param("Result", null, Gemini.Core.BL.DAL.SqlTypes.Int, System.Data.ParameterDirection.Output));
            }

            protected override void InitializeCommandText()
            {
                _commandText = "PIZB1200_Class_CountBySearch";
            }
        }

        class Command_RemoveBySearch : PI.FM.N000.Base.BL.DBD.BaseCommand<BO.Class>
        {
            public Command_RemoveBySearch() : base(PI.ZB.N1200.ELearning.BL.DBD.Class.DBD, Gemini.Core.BL.DBD.CommandType.StoredProcedure) { }

            protected override void InitializeParametrs()
            {
                Add(new Gemini.Core.BL.DBD.Param("SchoolID", Gemini.Core.BL.DAL.SqlTypes.BigInt));
                Add(new Gemini.Core.BL.DBD.Param("SchoolYearID", Gemini.Core.BL.DAL.SqlTypes.BigInt));
                Add(new Gemini.Core.BL.DBD.Param("InstructorID", Gemini.Core.BL.DAL.SqlTypes.BigInt));
                Add(new Gemini.Core.BL.DBD.Param("Name", Gemini.Core.BL.DAL.SqlTypes.NVarChar));
            }

            protected override void InitializeCommandText()
            {
                _commandText = "PIZB1200_Class_RemoveBySearch";
            }
        }
        #endregion
    }
}